//  Listing 10.6. Klasa Rational w wersji pozwalajcej 
//  na obsug mieszanych typw w wyraeniach

#include <iostream>
using namespace std;

class Rational 
{
long nmr, dnm;         		// prywatne dane
void normalize();             	// prywatne metody
public:
	// jeden "uniwersalny konstruktor": oglny, konwertujcy, domylny
Rational(long n=0, long d=1) 
  { nmr = n; dnm = d;  this->normalize(); }
	// obiekt docelowy jest niezmienny, dziki const:
Rational operator + (const Rational &x) const;
Rational operator - (const Rational &x) const;
Rational operator * (const Rational &x) const;
Rational operator / (const Rational &x) const;
	// a te metody bd modyfikowa docelowy obiekt (bez const):
void operator += (const Rational &x); 
void operator -= (const Rational &x);
void operator *= (const Rational &x);
void operator /= (const Rational &x);
	// obiekt docelowy jest niezmienny, dziki const:
bool operator == (const Rational &other) const; 
bool operator < (const Rational &other) const;
bool operator > (const Rational &other) const;
void show() const;
} ; 				// koniec specyfikacji klasy

Rational Rational::operator + (const Rational &x) const
  { return Rational(nmr*x.dnm + x.nmr*dnm, dnm*x.dnm); }
Rational Rational::operator - (const Rational &x) const
  { return Rational(nmr*x.dnm - x.nmr*dnm, dnm*x.dnm); }
Rational Rational::operator * (const Rational &x) const
  { return Rational(nmr * x.nmr, dnm * x.dnm); }
Rational Rational::operator / (const Rational &x) const
  { return Rational(nmr * x.dnm, dnm * x.nmr); }
void Rational::operator += (const Rational &x)
  { nmr = nmr * x.dnm + x.nmr * dnm; 		// 3/8+3/2=(6+24)/16=15/8
    dnm = dnm * x.dnm; 				// n1/d1+n2/d2 = (n1*d2+n2*d1)/(d1*d2)
    this->normalize(); }
void Rational::operator -= (const Rational &x)
{ 
  nmr = nmr * x.dnm - x.nmr * dnm; 		// 3/8+3/2=(6+24)/16=15/8
  dnm = dnm * x.dnm; 				// n1/d1+n2/d2 = (n1*d2-n2*d1)/(d1*d2)
  this->normalize(); 
}
void Rational::operator *= (const Rational &x)
{ 
  nmr = nmr * x.nmr; 
  dnm = dnm * x.dnm;
  this->normalize(); 
}
void Rational::operator /= (const Rational &x)
{ 
  nmr = nmr * x.dnm; 
  dnm = dnm * x.nmr;
  this->normalize(); 
}
bool Rational::operator == (const Rational &other) const
{ 
  return (nmr * other.dnm == dnm * other.nmr); 
}
bool Rational::operator < (const Rational &other) const
{ 
  return (nmr * other.dnm < dnm * other.nmr); 
}
bool Rational::operator > (const Rational &other) const
{ 
  return (nmr * other.dnm > dnm * other.nmr); 
}
void Rational::show() const
{ 
  cout << " " << nmr << "/" << dnm; 
}
void Rational::normalize() 		// prywatna metoda
{ 
  if (nmr == 0) { dnm = 1; return; 
}
int sign = 1;
if (nmr < 0) { sign = -1; nmr = -nmr; }
if (dnm < 0) { sign = -sign; dnm = -dnm; }
long gcd = nmr, value = dnm; 		// n.w.p.
while (value != gcd) { 
if (gcd > value)
gcd = gcd - value; 
else value = value - gcd; }
nmr = sign * (nmr/gcd); dnm = dnm/gcd; } 

int main()
{ 
cout << endl << endl;
Rational a(1,4), b(3,2), c, d;
c = a + 5; 			// Wyraenie c = 5 + a; omwimy pniej
a.show(); cout << " + " << 5 << " ="; c.show(); cout << endl;
d = b - 1;
b.show(); cout << " - " << 1 << " ="; d.show(); cout << endl;
c = a * 7;
a.show(); cout << " * " << 7 << " ="; c.show(); cout << endl;
d = b / 2;
b.show(); cout << " / " << 2 << " ="; d.show(); cout << endl;
c.show();
c += 3;
cout << " += " << 3 << " ="; c.show(); cout << endl;
d.show();
d *= 2;
cout << " *= " << 2 << " ="; d.show(); cout << endl;
if (b < 2)
  { b.show(); cout << " < " << 2 << endl; }
return 0;
}
